/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.Containers;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class FlowLayout
extends BaseParentComponent {
    protected final List<ModComponent> children = new ArrayList<ModComponent>();
    protected final List<ModComponent> childrenView = Collections.unmodifiableList(this.children);
    protected Size contentSize = Size.zero();

    protected FlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    protected void applyHorizontalContentSizing(Sizing sizing) {
        this.width = this.contentSize.width() + ((Insets)this.padding.get()).horizontal() + sizing.value * 2;
    }

    @Override
    protected void applyVerticalContentSizing(Sizing sizing) {
        this.height = this.contentSize.height() + ((Insets)this.padding.get()).vertical() + sizing.value * 2;
    }

    public FlowLayout child(ModComponent child) {
        this.children.add(child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(Collection<ModComponent> children) {
        this.children.addAll(children);
        this.updateLayout();
        return this;
    }

    public FlowLayout child(int index, ModComponent child) {
        this.children.add(index, child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(int index, Collection<ModComponent> children) {
        this.children.addAll(index, children);
        this.updateLayout();
        return this;
    }

    @Override
    public FlowLayout removeChild(ModComponent child) {
        if (this.children.remove(child)) {
            child.dismount(ModComponent.DismountReason.REMOVED);
            this.updateLayout();
        }
        return this;
    }

    public FlowLayout clearChildren() {
        for (ModComponent child : this.children) {
            child.dismount(ModComponent.DismountReason.REMOVED);
        }
        this.children.clear();
        this.updateLayout();
        return this;
    }

    @Override
    public List<ModComponent> children() {
        return this.childrenView;
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(matrices, mouseX, mouseY, partialTicks, delta, this.children);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        List components = UIParsing.get(children, "children", e -> UIParsing.allChildrenOfType(e, (short)1)).orElse(Collections.emptyList());
        for (Element child : components) {
            this.child(model.parseComponent(ModComponent.class, child));
        }
    }

    public static FlowLayout parse(Element element) {
        UIParsing.expectAttributes(element, "direction");
        return element.getAttribute("direction").equals("vertical") ? Containers.verticalFlow(Sizing.content(), Sizing.content()) : Containers.horizontalFlow(Sizing.content(), Sizing.content());
    }
}

